<?php

namespace App\Console\Commands;

use App\Http\Helper;
use Config;
use GearmanJob;
use Illuminate\Console\Command;

class Worker extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'worker';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(){
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle(){
        Helper::createWorker('Hello', $this);
    }

    public function Worker(GearmanJob $job){
        $url = $job->workload();
        $urls = Config::get('urls');
        Helper::tor();

        foreach(array_keys($urls) as $get){
            $right_way = $url.'/'.$get;
            $result = $this->runner($urls, $url, $get, $right_way);
            if(!is_null($result)){
                return $result;
            }
            if(isset($urls[$get]['pre'])){
                foreach($urls[$get]['pre'] as $pre){
                    $right_way = parse_url($url, PHP_URL_SCHEME).'://'.$pre.'.'.parse_url($url, PHP_URL_HOST).'/'.$get;
                    $result = $this->runner($urls, $url, $get, $right_way);
                    if(!is_null($result)){
                        return $result;
                    }
                }
            }
        }

        return false;
    }

    private function runner($urls, $url, $get, $right_way){
        if($html = Helper::query($right_way)){
            if(isset($urls[$get]['need'])){
                foreach($urls[$get]['need'] as $pattern){
                    if(preg_match('#'.$pattern.'#i', $html)){
                        return json_encode([
                            'url' => $url,
                            'right_way' => $right_way,
                        ]);
                    }
                }
            }else{
                return json_encode([
                    'url' => $url,
                    'right_way' => $right_way,
                ]);
            }
        }

        return null;
    }
}
